/* global jQuery:false */

(function() {
	"use strict";

	jQuery(document).on('action.init_hidden_elements', trx_addons_cf7_init);
	
	function trx_addons_cf7_init(e, container) {
		if (container === undefined) container = jQuery('body');
		if (container.length === undefined || container.length === 0) return;
		
		// Close button in the messagebox
		container.find('.wpcf7:not(.alert_inited)').each( function() {
			var form = jQuery(this);
			form
				.addClass('alert_inited')
				.on('wpcf7:submit', function(e, details) {
					form.find('.wpcf7-response-output').addClass('trx_addons_message_box trx_addons_message_box_error');
				})
				.on('keypress change', function() {
					form.find('.wpcf7-response-output:visible').slideUp();
				} );
		} );
	}
	
})();
