<?php
/**
 * Plugin's admin functions
 *
 * @package ThemeREX Addons
 * @since v1.6.17
 */

// Don't load directly
if ( ! defined( 'TRX_ADDONS_VERSION' ) ) {
	exit;
}


// Refresh taxonomies list on change parent list
//--------------------------------------------------------------------------------------------

// Get specified list's items
if ( !function_exists( 'trx_addons_callback_refresh_list' ) ) {
	add_action('wp_ajax_trx_addons_refresh_list', 		'trx_addons_callback_refresh_list');
	add_action('wp_ajax_nopriv_trx_addons_refresh_list','trx_addons_callback_refresh_list');
	function trx_addons_callback_refresh_list() {
		trx_addons_verify_nonce();
		if ( empty( $_REQUEST['parent_value'] ) ) {
			$new_list = array();
		} else {
			$list = apply_filters('trx_addons_filter_refresh_list_'.trim($_REQUEST['parent_type']),
									array(),
									$_REQUEST['parent_value'],
									is_string($_REQUEST['list_not_selected'])
										? $_REQUEST['list_not_selected']==='true' 
										: $_REQUEST['list_not_selected']
								);
			// Make simple list to save sort order of items
			$new_list = array();
			foreach ($list as $k=>$v) {
				$new_list[] = array('key' => $k, 'value' => strip_tags($v));
			}
		}
		if ( count( $new_list ) == 0 ) {
			$new_list[] = array( 'key' => 0, 'value' => __('- Empty -', 'trx_addons' ) );
		}
		$response = array(
			'error' => '',
			'data' => $new_list
		);
		trx_addons_ajax_response( $response );
	}
}

// Get list taxonomies
if ( !function_exists( 'trx_addons_admin_refresh_list_taxonomies' ) ) {
	add_filter('trx_addons_filter_refresh_list_taxonomies', 'trx_addons_admin_refresh_list_taxonomies', 10, 3);
	function trx_addons_admin_refresh_list_taxonomies($list, $post_type, $not_selected=false) {
		return trx_addons_get_list_taxonomies(false, $post_type);
	}
}

// Get list terms
if ( !function_exists( 'trx_addons_admin_refresh_list_terms' ) ) {
	add_filter('trx_addons_filter_refresh_list_terms', 'trx_addons_admin_refresh_list_terms', 10, 3);
	function trx_addons_admin_refresh_list_terms($list, $taxonomy, $not_selected=false) {
		$rez = array();
		if ($not_selected && !empty( $taxonomy ) ) {
			$tax_obj = get_taxonomy($taxonomy);
			if ( is_object( $tax_obj ) ) {
				$rez[0] = sprintf(__('- %s -', 'trx_addons'), $tax_obj->label);
			}
		}
		return trx_addons_array_merge(
					$rez, 
					trx_addons_get_list_terms(false, $taxonomy)
					);
	}
}


// Show <select> with categories in the admin filters area
//-----------------------------------------------------------------------------------
if (!function_exists('trx_addons_admin_filters')) {
	function trx_addons_admin_filters($post_type, $tax) {
		if (get_query_var('post_type') != $post_type) return;

		if ( !($terms = get_transient("trx_addons_terms_filter_".trim($tax)))) {
			$terms = get_terms($tax);
			set_transient("trx_addons_terms_filter_".trim($tax), $terms, 24*60*60);
		}

		$list = '';
		if (is_array($terms) && count($terms) > 0) {
			$tax_obj = get_taxonomy($tax);
			$list .= '<select name="'.esc_attr($tax).'" id="'.esc_attr($tax).'" class="postform">'
					.  "<option value=''>" . esc_html($tax_obj->labels->all_items) . "</option>";
			foreach ($terms as $term) {
				$list .= '<option value="'. esc_attr($term->slug) . '"'
							. (isset($_REQUEST[$tax]) 
								&& $_REQUEST[$tax] == $term->slug 
								|| (isset($_REQUEST['taxonomy']) 
										&& $_REQUEST['taxonomy'] == $tax 
										&& isset($_REQUEST['term']) 
										&& $_REQUEST['term'] == $term->slug
									) 
								? ' selected="selected"' 
								: '') 
							. '>' . esc_html($term->name) . '</option>';
			}
			$list .=  "</select>";
		}
		trx_addons_show_layout($list);
	}
}
  
// Clear terms cache on the taxonomy save
if (!function_exists('trx_addons_admin_clear_cache_terms')) {
	function trx_addons_admin_clear_cache_terms($tax) {  
		// verify nonce
		$ok = true;
		if (!empty($_REQUEST['_wpnonce_add-tag'])) {
			check_admin_referer( 'add-tag', '_wpnonce_add-tag' );
		} else if (!empty($_REQUEST['_wpnonce']) && !empty($_REQUEST['tag_ID'])) {
			$tag_ID = (int) $_REQUEST['tag_ID'];
			if ($_POST['action'] == 'editedtag')
				check_admin_referer( 'update-tag_' . $tag_ID );
			else if ($_POST['action'] == 'delete-tag')
				check_admin_referer( 'delete-tag_' . $tag_ID );
			else if ($_POST['action'] == 'delete')
				check_admin_referer( 'bulk-tags' );
			else if ($_POST['action'] == 'bulk-delete')
				check_admin_referer( 'bulk-tags' );
			else
				$ok = false;
		} else
			$ok = false;
		if ($ok) 
			set_transient("trx_addons_terms_filter_".trim($tax), '', 24*60*60);
	}
}

	
// Add JS-vars to the admin area
//-----------------------------------------------
if (!function_exists('trx_addons_admin_localize_script')) {
	add_filter('trx_addons_filter_localize_script_admin', 'trx_addons_admin_localize_script');
	function trx_addons_admin_localize_script($vars) {
		// Theme-specific columns class
		$vars['columns_wrap_class']          = trx_addons_get_columns_wrap_class();
		$vars['column_class_template']       = trx_addons_get_column_class_template();

		// E-mail mask to validate forms
		$vars['email_mask']                  = '^([a-zA-Z0-9_\\-]+\\.)*[a-zA-Z0-9_\\-]+@[a-zA-Z0-9_\\-]+(\\.[a-zA-Z0-9_\\-]+)*\\.[a-zA-Z0-9]{2,6}$';
		// Messages
		$vars['msg_caption_yes']             = esc_html__( 'Yes', 'trx_addons' );
		$vars['msg_caption_no']              = esc_html__( 'No', 'trx_addons' );
		$vars['msg_caption_ok']              = esc_html__( 'OK', 'trx_addons' );
		$vars['msg_caption_apply']           = esc_html__( 'Apply', 'trx_addons' );
		$vars['msg_caption_cancel']          = esc_html__( 'Cancel', 'trx_addons' );
		$vars['msg_caption_attention']       = esc_html__( 'Attention!', 'trx_addons' );
		$vars['msg_caption_warning']         = esc_html__( 'Warning!', 'trx_addons' );
		$vars['msg_reset']                   = esc_html__( 'Reset', 'trx_addons' );
		$vars['msg_reset_confirm']           = esc_html__( 'Are you sure you want to reset all Theme Options?', 'trx_addons' );
		$vars['msg_export']                  = esc_html__( 'Export', 'trx_addons' );
		$vars['msg_export_options']          = esc_html__( 'Copy options and save to the text file.', 'trx_addons' );
		$vars['msg_import']                  = esc_html__( 'Import', 'trx_addons' );
		$vars['msg_import_options']          = esc_html__( 'Paste previously saved options from the text file.', 'trx_addons' );
		$vars['msg_import_error']            = esc_html__( 'Error occurs while import options!', 'trx_addons' );
		$vars['msg_activate_theme']          = esc_html__( 'Theme Activation', 'trx_addons' );
		$vars['msg_activate_theme_agree']    = esc_html__( 'If you do not check the checkbox - your name and email will not be transferred to the server and we will not be able to automatically register you in our support system. Continue?', 'trx_addons' );
		$vars['msg_deactivate_theme']        = esc_html__( 'Attention!', 'trx_addons' );
		$vars['msg_deactivate_theme_agree']  = esc_html__( "After the domain disconnection, you won't be able to install demo data and bundled plugins, as well as receive support for the theme installed on this domain.", 'trx_addons' );
		$vars['msg_deactivate_theme_bt_yes'] = esc_html__( 'Yes, I understand. Disconnect domain', 'trx_addons' );
		$vars['msg_deactivate_theme_bt_no']  = esc_html__( 'Go back', 'trx_addons' );
		$vars['msg_deactivate_theme_error']  = esc_html__( 'Theme deactivation error! Unexpected server answer!', 'trx_addons' );
		$vars['msg_field_email_not_valid']   = esc_html__( 'Invalid email address', 'trx_addons' );
		$vars['msg_specify_purchase_code']   = esc_html__( 'Please, specify the purchase code!', 'trx_addons' );
		return $vars;
	}
}
