<?php
/**
 * Widget: Users list (Shortcodes)
 *
 * @package ThemeREX Addons
 * @since v1.84.0
 */

// Don't load directly
if ( ! defined( 'TRX_ADDONS_VERSION' ) ) {
	exit;
}


// Load required styles and scripts for the frontend
if ( !function_exists( 'trx_addons_sc_users_load_scripts_front' ) ) {
	add_action("wp_enqueue_scripts", 'trx_addons_sc_users_load_scripts_front');
	function trx_addons_sc_users_load_scripts_front() {
		if (trx_addons_is_on(trx_addons_get_option('debug_mode'))){
			wp_enqueue_style( 'trx_addons-sc_users', trx_addons_get_file_url(TRX_ADDONS_PLUGIN_SHORTCODES . 'users/users.css'), array(), null );
		}
	}
}

// Load responsive styles for the frontend
if ( !function_exists( 'trx_addons_sc_users_load_responsive_styles' ) ) {
	add_action("wp_enqueue_scripts", 'trx_addons_sc_users_load_responsive_styles', 2000);
	function trx_addons_sc_users_load_responsive_styles() {
		if (trx_addons_is_on(trx_addons_get_option('debug_mode'))) {
			wp_enqueue_style( 'trx_addons-sc_users-responsive', trx_addons_get_file_url(TRX_ADDONS_PLUGIN_SHORTCODES . 'users/users.responsive.css'), array(), null );
		}
	}
}

// Merge widget specific styles into single stylesheet
if ( !function_exists( 'trx_addons_sc_users_merge_styles' ) ) {
	add_filter("trx_addons_filter_merge_styles", 'trx_addons_sc_users_merge_styles');
	function trx_addons_sc_users_merge_styles($list) {
		$list[] = TRX_ADDONS_PLUGIN_SHORTCODES . 'users/users.css';
		return $list;
	}
}


// Merge widget's specific styles to the single stylesheet (responsive)
if ( !function_exists( 'trx_addons_sc_users_merge_styles_responsive' ) ) {
	add_filter("trx_addons_filter_merge_styles_responsive", 'trx_addons_sc_users_merge_styles_responsive');
	function trx_addons_sc_users_merge_styles_responsive($list) {
		$list[] = TRX_ADDONS_PLUGIN_SHORTCODES . 'users/users.responsive.css';
		return $list;
	}
}



// trx_sc_users
//-------------------------------------------------------------
/*
[trx_sc_users id="unique_id" title="Widget title" number="3"]
*/
if ( !function_exists( 'trx_addons_sc_users' ) ) {
	function trx_addons_sc_users($atts, $content=null){	
		$atts = trx_addons_sc_prepare_atts('trx_sc_users', $atts, trx_addons_sc_common_atts('id,title,slider', array(
			// Individual params
			"type" => 'default',
			"roles" => array('author'),
			"number" => 4,
			"columns" => 0,
			))
		);

		ob_start();
		trx_addons_get_template_part(
			array(
				TRX_ADDONS_PLUGIN_SHORTCODES . 'users/tpl.'.trx_addons_esc($atts['type']).'.php',
				TRX_ADDONS_PLUGIN_SHORTCODES . 'users/tpl.default.php'
				),
			'trx_addons_args_sc_users', 
			$atts
		);
		$output = ob_get_contents();
		ob_end_clean();

		return apply_filters('trx_addons_sc_output', $output, 'trx_sc_users', $atts, $content);
	}
}


// Add shortcode [trx_sc_users]
if (!function_exists('trx_addons_sc_users_add_shortcode')) {
	function trx_addons_sc_users_add_shortcode() {
		add_shortcode("trx_sc_users", "trx_addons_sc_users");
	}
	add_action('init', 'trx_addons_sc_users_add_shortcode', 20);
}


// Add shortcodes
//----------------------------------------------------------------------------

// Add shortcodes to Elementor
if ( trx_addons_exists_elementor() && function_exists('trx_addons_elm_init') ) {
	require_once TRX_ADDONS_PLUGIN_DIR . TRX_ADDONS_PLUGIN_SHORTCODES . 'users/users-sc-elementor.php';
}

// Add shortcodes to Gutenberg
if ( trx_addons_exists_gutenberg() && function_exists( 'trx_addons_gutenberg_get_param_id' ) ) {
	require_once TRX_ADDONS_PLUGIN_DIR . TRX_ADDONS_PLUGIN_SHORTCODES . 'users/users-sc-gutenberg.php';
}

// Create our widget
require_once TRX_ADDONS_PLUGIN_DIR . TRX_ADDONS_PLUGIN_SHORTCODES . 'users/users-widget.php';
