<?php $__env->startSection('title', 'Kodovi'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-2">
                <?php echo $__env->make('admin.departments.navigation', ['departments' => $departments, 'activeDepartment' => $department->id, 'routeLink' => 'admin.departments.codes.index'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-10">
                <div class="d-flex justify-content-end mb-3">
                    <a class="btn btn-secondary mr-1" href="<?php echo e(route('admin.departments.codes.create', $department->id)); ?>">Generiši kodove</a>
                </div>

                <ul class="nav nav-tabs" id="semesters" role="tablist">
                    <?php $__currentLoopData = $codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester => $semesterCodes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a
                                    class="nav-link <?php if($loop->first): ?> active <?php endif; ?> "
                                    id="<?php echo e($semester); ?>-tab"
                                    data-toggle="tab"
                                    href="#semester-<?php echo e($semester); ?>"
                                    role="tab"
                                    aria-controls="semester-<?php echo e($semester); ?>"
                                    <?php if($loop->first): ?>
                                    aria-selected="true"
                                    <?php endif; ?>
                            ><?php echo e($semester); ?>. semestar</a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div class="tab-content mt-4">
                    <?php $__currentLoopData = $codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester => $semesterCodes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tab-pane <?php if($loop->first): ?> active <?php endif; ?>" id="semester-<?php echo e($semester); ?>" role="tabpanel" aria-labelledby="<?php echo e($semester); ?>-tab">
                            <div class="d-flex justify-content-end mb-2">
                                <a
                                    href="<?php echo e(route('admin.codes.print', ['department' => $department, 'semester' => $semester])); ?>"
                                    target="_blank"
                                    class="btn btn-secondary">
                                    Odštampaj kodove za <?php echo e($semester); ?>. semestar
                                </a>
                            </div>
                            <table class="table">
                                <thead class="thead-dark">
                                    <th scope="col">
                                        Kod
                                    </th>
                                    <th scope="col">
                                        Smer
                                    </th>
                                    <th scope="col">
                                        Semestar
                                    </th>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $semesterCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th class="align-middle" scope="row"><?php echo e($code->code); ?></th>
                                            <td class="align-middle"><?php echo e($department->name); ?></td>
                                            <td class="align-middle"><?php echo e($semester); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <?php if($codes->isEmpty()): ?>
                    <div class="h2 text-center">
                        Nema neupotrebljenih kodova
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/misakovic1/Projekti/anketa/resources/views/admin/codes/index.blade.php ENDPATH**/ ?>