@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Пријави се</div>

                <div class="card-body">
                    <div class="text-center w-100">
                        <img src="/images/logo_akademije_ng.png" class="w-50"/>
                    </div>
                    <br />
                    <form method="POST" action="{{ route('login') }}">
                        @csrf
                        <input type="hidden" name="remember" value="1">

                        <div class="form-group row">
                            <label for="email" class="col-md-4 col-form-label text-md-right">Унеси код</label>

                            <div class="col-md-6">
                                <input id="code" type="text" class="form-control @error('code') is-invalid @enderror" name="code" value="{{ old('code') }}" required autofocus>

                                @error('code')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                            <div class="col-md-12 offset-md-4 text-center">
                                <button type="submit" id="loginbtn" class="btn btn-primary">
                                    Пријави се
                                </button>
                            </div>
                            <div class="col-md-12 offset-md-4 text-center">
                                @if(Settings::get('codes-public'))
                                    <a class="btn btn-link" href="{{ route('codes.index') }}">Kодови за пријављивање</a>
                                @endif
                            </div>
                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
