@extends('layouts.admin')

@section('title', 'Питање')

@section('content')
    <div class="container">
        <div class="col-md-12">
            <div class="d-flex justify-content-start">
                На сва питања се одговор даје у виду оцене од 1 до 5 осим за категорију текстуални одговори.
            </div>
            <div class="d-flex justify-content-end mb-3">
                <a class="btn btn-secondary mr-1" href="{{ route('admin.questions.create') }}">Додај питање</a>
            </div>

            <div class="mt-4">
                <ul class="nav nav-tabs" id="questions" role="tablist">

                    
                    <li class="nav-item">
                        <a
                                class="nav-link active"
                                id="subject-tab"
                                data-toggle="tab"
                                href="#subject-questions"
                                role="tab"
                                aria-controls="subject-questions"
                        >О предметима</a>
                    </li>

                    <li class="nav-item">
                        <a
                                class="nav-link"
                                id="teacher-tab"
                                data-toggle="tab"
                                href="#teacher-questions"
                                role="tab"
                                aria-controls="teacher-questions"
                                aria-selected="true"
                        >О професорима</a>
                    </li>


                    <li class="nav-item">
                        <a
                                class="nav-link"
                                id="other-tab"
                                data-toggle="tab"
                                href="#other-questions"
                                role="tab"
                                aria-controls="other-questions"
                        >О школи</a>
                    </li>
                    <li class="nav-item">
                        <a
                                class="nav-link"
                                id="textanswer-tab"
                                data-toggle="tab"
                                href="#textanswer-questions"
                                role="tab"
                                aria-controls="textanswer-questions"
                        >Текст одговори</a>
                    </li>
                    <li class="nav-item">
                        <a
                                class="nav-link"
                                id="other-tab"
                                data-toggle="tab"
                                href="#semesters-questions"
                                role="tab"
                                aria-controls="semesters-questions"
                        >О прошлом семестру</a>
                    </li>
                </ul>

                <div class="tab-content mt-4">
                    

                    <div class="tab-pane active" id="subject-questions" role="tabpanel" aria-labelledby="subject-tab">
                        <table class="table">
                            <thead class="thead-dark">
                                <th scope="col">
                                    Р.број
                                </th>
                            <th scope="col">
                                Питање
                            </th>
                            <th scope="col" style="width:7em">
                                Опције
                            </th>
                            </thead>
                            <tbody>
                            @foreach ($questions->get('subject') ?? [] as $question)
                                <tr>
                                    <td class="align-middle text-center" style="width:40px" scope="row">{{ $question->number }}</td>
                                    <td class="align-middle" scope="row">{{ $question->text }}</td>
                                    <td>
                                        <div class="row text-center">
                                            <div class="mr-1 pb-1">
                                                @include('admin.partials.buttons.delete', [
                                                    'url' => route('admin.questions.destroy', $question->id),
                                                    'modalId' => "delete-{$question->id}-modal",
                                                    'modalTitle' => 'Брисање питања',
                                                    'modalText' => "Потврди брисање питања \"{$question->text}\"",
                                                ])
                                            </div>
                                            <div class="mr-1 pb-1">
                                                @include('admin.partials.buttons.edit', ['url' => route('admin.questions.edit', $question->id)])
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="tab-pane" id="teacher-questions" role="tabpanel" aria-labelledby="teacher-tab">
                        <table class="table">
                            <thead class="thead-dark">
                            <th scope="col">
                                Р.број
                            </th>
                            <th scope="col">
                                Питање
                            </th>
                            <th scope="col" class="text-center" style="width:7em">
                                Опције
                            </th>
                            </thead>
                            <tbody>
                            @foreach ($questions->get('teacher') ?? [] as $question)
                                <tr>
                                    <td class="align-middle text-center" style="width:40px" scope="row">{{ $question->number }}</td>
                                    <td class="align-middle" scope="row">{{ $question->text }}</td>
                                    <td>
                                        <div class="row">
                                            <div class="mr-1 pb-1">
                                                @include('admin.partials.buttons.delete', [
                                                    'url' => route('admin.questions.destroy', $question->id),
                                                    'modalId' => "delete-{$question->id}-modal",
                                                    'modalTitle' => 'Брисање питања',
                                                    'modalText' => "Потврди брисање питања \"{$question->text}\"",
                                                ])
                                            </div>
                                            <div class="mr-1 pb-1">
                                                @include('admin.partials.buttons.edit', ['url' => route('admin.questions.edit', $question->id)])
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="tab-pane" id="other-questions" role="tabpanel" aria-labelledby="other-tab">
                        <table class="table">
                            <thead class="thead-dark">
                                <th scope="col">
                                    Р.број
                                </th>
                            <th scope="col">
                                Питање
                            </th>
                            <th scope="col" style="width:7em">
                                Опције
                            </th>
                            </thead>
                            <tbody>
                            @foreach ($questions->get('other') ?? [] as $question)
                                <tr>
                                    <td class="align-middle text-center" style="width:40px" scope="row">{{ $question->number }}</td>
                                    <td class="align-middle" scope="row">{{ $question->text }}</td>
                                    <td>
                                        <div class="row text-center">
                                            <div class="mr-1 pb-1">
                                                @include('admin.partials.buttons.delete', [
                                                    'url' => route('admin.questions.destroy', $question->id),
                                                    'modalId' => "delete-{$question->id}-modal",
                                                    'modalTitle' => 'Брисање питања',
                                                    'modalText' => "Потврди брисање питања \"{$question->text}\"",
                                                ])
                                            </div>
                                            <div class="mr-1 pb-1">
                                                @include('admin.partials.buttons.edit', ['url' => route('admin.questions.edit', $question->id)])
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="tab-pane" id="textanswer-questions" role="tabpanel" aria-labelledby="textanswer-tab">
                        <table class="table">
                            <thead class="thead-dark">
                                <th scope="col">
                                    Р.број
                                </th>
                            <th scope="col">
                                Питање
                            </th>
                            <th scope="col"  style="width:7em">
                                Опције
                            </th>
                            </thead>
                            <tbody>
                            @foreach ($questions->get('textanswer') ?? [] as $question)
                                <tr>
                                    <td class="align-middle text-center" style="width:40px" scope="row">{{ $question->number }}</td>
                                    <td class="align-middle" scope="row">{{ $question->text }}</td>
                                    <td>
                                        <div class="row text-center">
                                            <div class="mr-1 pb-1">
                                                @include('admin.partials.buttons.delete', [
                                                    'url' => route('admin.questions.destroy', $question->id),
                                                    'modalId' => "delete-{$question->id}-modal",
                                                    'modalTitle' => 'Брисање питања',
                                                    'modalText' => "Потврди брисање питања \"{$question->text}\"",
                                                ])
                                            </div>
                                            <div class="mr-1 pb-1">
                                                @include('admin.partials.buttons.edit', ['url' => route('admin.questions.edit', $question->id)])
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>


                    <div class="tab-pane" id="semesters-questions" role="tabpanel" aria-labelledby="semesters-tab">
                        <table class="table">
                            <thead class="thead-dark">
                                <th scope="col">
                                    Р.број
                                </th>
                            <th scope="col">
                                Питање
                            </th>
                            <th scope="col" style="width:7em">
                                Опције
                            </th>
                            </thead>
                            <tbody>
                            @foreach ($questions->get('semesters') ?? [] as $question)
                                <tr>
                                    <td class="align-middle text-center" style="width:40px" scope="row">{{ $question->number }}</td>
                                    <td class="align-middle" scope="row">{{ $question->text }}</td>
                                    <td>
                                        <div class="row text-center">
                                            <div class="mr-1 pb-1">
                                                @include('admin.partials.buttons.delete', [
                                                    'url' => route('admin.questions.destroy', $question->id),
                                                    'modalId' => "delete-{$question->id}-modal",
                                                    'modalTitle' => 'Брисање питања',
                                                    'modalText' => "Потврди брисање питања \"{$question->text}\"",
                                                ])
                                            </div>
                                            <div class="mr-1 pb-1">
                                                @include('admin.partials.buttons.edit', ['url' => route('admin.questions.edit', $question->id)])
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
