<?php

namespace App\Services\Calculators;

use App\Models\Question;

class SubjectByStandardAnswers extends CalculatorByStandard
{
    public function calculate(AnswerSet $answerSet, int $standard)
    {
        $questions = $answerSet->getSubjectByStandardQuestions($standard);
        $answers = $answerSet->getSubjectByStandardAnswers($standard);

        return $questions->keyBy('id')->map(function (Question $question) use ($answers) {
            return $this->formatDecimal($answers->where('question_id', $question->id)->average->mark);
        });
    }
}