<?php
    /** @var \Illuminate\Support\Collection|\App\Models\Department[] $departments */
    /** @var \App\Models\Department $department */
    /** @var \Illuminate\Support\Collection|\App\Models\Code[] $departmentCodes */
?>


<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <h1>
                Кодови за попуњавање анкете
            </h1>
        </div>

        <div class="row justify-content-center">
            <div class="col-md-2">
                <?php echo $__env->make('admin.departments.navigation', [
                    'departments' => $departments,
                    'activeDepartment' => $department->id,
                    'routeLink' => 'codes.show',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-10">
                <ul class="nav nav-tabs" id="semesters" role="tablist">
                    <?php $__currentLoopData = $departmentCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester => $semesterCodes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a
                                class="nav-link"
                                id="<?php echo e($semester); ?>-tab"
                                data-toggle="tab"
                                href="#semester-<?php echo e($semester); ?>"
                                role="tab"
                                aria-controls="semester-<?php echo e($semester); ?>"
                                <?php if($loop->first): ?>
                                aria-selected="true"
                                <?php endif; ?>
                            ><?php echo e($semester); ?>. семестар</a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div class="tab-content mt-4">
                    <?php $__currentLoopData = $departmentCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester => $semesterCodes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tab-pane" id="semester-<?php echo e($semester); ?>" role="tabpanel" aria-labelledby="<?php echo e($semester); ?>-tab">
                            <a class="btn btn-secondary float-right mb-3" href="<?php echo e(route('login')); ?>">Започни анкету</a>

                            <table class="table table-bordered content-center">
                                <thead class="thead-dark">
                                <th scope="col" colspan="3" class="text-center">
                                    Кодови
                                </th>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $semesterCodes->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $codesChunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <?php $__currentLoopData = $codesChunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td class="text-center"><?php echo e($code->code); ?></td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akademij/public_html/anketa-vranje/resources/views/codes.blade.php ENDPATH**/ ?>