<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    const TYPE_TEACHER   = 'teacher';
    const TYPE_SUBJECT   = 'subject';
    const TYPE_OTHER     = 'other';
    const TYPE_SEMESTERS = 'semesters';
    const TYPE_TEXTANSWER = 'textanswer';

    const TYPE_OPTIONS = [
        self::TYPE_TEACHER      => 'O наставнику',
        self::TYPE_SUBJECT      => 'O предмету',
        self::TYPE_OTHER        => 'O школи',
        self::TYPE_TEXTANSWER   => 'Текст одговори',
        self::TYPE_SEMESTERS    => 'O прошлом семестру',
    ];

    protected $fillable = [
        'number', 'text', 'type' 
    ];

    public function isTeacher()
    {
        return $this->type === self::TYPE_TEACHER;
    }

    public function isSubject()
    {
        return $this->type === self::TYPE_SUBJECT;
    }

    public function isOther()
    {
        return $this->type === self::TYPE_OTHER;
    }

    public function isSemesters()
    {
        return $this->type === self::TYPE_SEMESTERS;
    }

    public function isTextAnswer()
    {
        return $this->type === self::TYPE_TEXTANSWER;
    }
}
