<?php
    $odsek = config('app.admin_url');
    $odsekime = "АТВСС НИШ";
    switch($odsek){
        case "admin.localhost":
            $odsekime = "Одсек Врање";
            break;
        case "admin.anketa.ov.akademijanis.edu.rs":
            $odsekime = "Одсек Врање";
            break;
        case "admin.anketa.on.akademijanis.edu.rs":
            $odsekime = "Одсек Ниш";
            break;
        case "admin.anketa.op.akademijanis.edu.rs":
            $odsekime = "Одсек Пирот";
            break;
        default:
            $odsekime = "Одсек Ниш";
            break;
    }

    //foreach ($departments as $department)
   // {
   //     echo $department->avg($department->get("subjectByStandardAnswers")[4]);
   //     dd($department);
   // }

   // ini_set('memory_limit', '-1');
    //echo '<pre>' . print_r(get_defined_vars(), true) . '</pre>';
    // {{dd(get_defined_vars())}}
    //echo "/////";
    ?>

<!DOCTYPE html>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!--<link rel="stylesheet" href="./snow.css" stylesheet="text/css">-->
    <title>Извештај</title>
    
    <style>
        .wrap{
            overflow: visible;
            min-width: 595px;
            max-width: 968px;
            /*height: 842px;*/
            display: flex;
            flex-direction: column;
            margin: auto;
        }
        .header{
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            align-content: space-between;
            margin-top: 5px;
        }
        .header .text{
            width: 300px;
            margin-top: 20px;
            text-align: center;
            padding-right: 30px;
        }
        .header .logo{
            padding-right: 50px;
        }
        .mini-table-wrap{
            margin-top: 50px;
            margin-bottom: 30px;
        }
        .mini-table-wrap .mini-table{
            border: 1px solid black;
        }
        .mini-table tr td{
            border: 1px solid black;
            font-size: 1em;
            font-weight: bold;
            text-align: center;
        }
        .paragraph-text{

            font-size: 1em;
            text-align: justify;
            /*text-align: left;*/
        }
        .tabela{
            table-layout: fixed;
            border-collapse: collapse;
            /*page-break-inside: always;*/
        }
        .tabela tr th{
            border: 1px solid black;
            text-align: center;
            padding: 4px 4px;
            font-size: 0.6em;
            



        }
        .tabela tr td{
            padding: 4px 4px;
            border: 1px solid black;
            text-align: center;
            font-weight: bold;
            font-size: 0.5em;


            /*display: block;*/

        }
        .tabela .last{
            font-size: 1em;
            background-color: #a39b60;
        }
        .small tr td{
            /*display: block;*/
            font-size: 1em;
            padding: 5px 10px;
            text-align: center;
            border: 1px solid black;

        }
        .small tr td:first-child{
            text-align: left;
            padding-left: 10px;
        }

        .header-2{
            text-align: center;
            font-size: 1.4em;
            color: #fff;
            width: 400px;
            background-color: #0f64c0;
            border: 1px solid black;
            margin: 0 auto;
            padding: 5px auto;
            page-break-before:always;

        }
        .mini-head{
            text-decoration: underline;
            font-size: 1em;
        }
        td, th, tr {
            overflow: visible;
            page-break-inside: avoid;
        }
        @media  print {
          .header-2, .mini-head{ page-break-before: always; }
          table { page-break-after:auto }
          tr    { page-break-inside:avoid; page-break-after:auto }
          td    { page-break-inside:avoid; page-break-after:auto }
        }

    </style>
</head>
<body>
<div class="container">
    <div class="wrap">
    <div class="header">
        <div class="text"><b>Академија техничко-васпитачких струковних студија Ниш - <?php echo e($odsekime); ?></b></div>
        <!--<img src="<?php echo e(asset('public/images/logo_akademije.jpg')); ?>"> -->
    </div>
    <div class="mini-table-wrap">
        <table class="mini-table" style="page-break-inside:avoid;">
            <tr>
                <td>Извештај Комисије за обезбеђење квалитета о студентском вредновању педагошког рада наставника и сарадника, квалитета наставних предмета и средстава и рада стручних служби у зимском семестру шк. <?php echo e($schoolYear); ?>. год.</td>
            </tr>
        </table>
    </div>
    <div class="paragraph-text" style="text-indent: 50px; text-">
        У поступку анкетирања учествовало је <b><?php echo e($surveyedCount); ?></b> од укупно <b><?php echo e($studentTotal); ?></b> првоуписаних студената <b>(<?php echo e($surveyedPerc); ?>%)</b> са свих акредитованих студијских програма основних, специјалистичких и мастер струковних студија, на свим годинама студија. Врeднован је педагошки рад наставника и сарадника на предметима зимског семестра школске <?php echo e($schoolYear); ?>, квалитет самих предмета и наставних средстава, као и рад стручних служби и хигијене у Школи.

    </div>
    <div class="paragraph-text" style="text-indent: 50px;">
        Поступак анкетирања је спровела Студентска служба, на јединствен начин за све студенте, током овере семестра. У поступку припреме материјала, начина и рокова спровођења анкетирања, Студентска служба је имала стручну помоћ од стране Комисије за обезбеђење квалитета. Комисија је извршила обраду анкетних листића, а на основу резултата анкетирања је израдила и овај извештај, по студијским програмима и на нивоу целе Школе.
    </div>
    <br>
    <br>
    <div class="paragraph-text">
        <b>Напомена</b>: Комисија је списак предмета и наставника који изводе наставу на тим предметима, добила од студентске службе (којој су шефови студијских програма потврдили исправност списка).
    </div>


    <br>
    <div class="header-2 paragraph-text">
        Стандард 4: Студентска процена квалитета студијског програма 
    </div>
    <br>
    <div class="paragraph-text">
        Табела 1. Стандард 4
    </div>
    <table class="tabela" style="page-break-inside:avoid;">
        <tr>
            <th>Студијски програм</th>
            <?php $__currentLoopData = $standardsQuestions[4]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <th><?php echo e($question->text); ?></th>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tr>
        <tbody style="page-break-inside:avoid;">
        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($department->get('name')); ?></td>
                <?php $__currentLoopData = $standardsQuestions[4]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td><?php echo e($department->get("subjectByStandardAnswers")[4]->get($question->id)); ?></td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr style="background-color: #d3d19d;">
            <td><?php echo e($odsekime); ?> - Стандард 4. укупно</td>
            <?php $__currentLoopData = $standardsQuestions[4]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td><?php echo e($standardsAverageMark[4]->get($question->id)); ?></td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        </tbody>
    </table>
    <br>

    <br>
    <div class="header-2 paragraph-text">
        Стандард 5: Студентска процена квалитета наставног процеса
    </div>
    <br>
    <div class="paragraph-text">
        Табела 2. Стандард 5
    </div>
    <table class="tabela" style="page-break-inside:avoid;">
        <tr>
            <th>Студијски програм</th>
            <?php $__currentLoopData = $standardsQuestions[5]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <th><?php echo e($question->text); ?></th>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tr>
        <tbody style="page-break-inside:avoid;">
        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($department->get('name')); ?></td>
                <?php $__currentLoopData = $standardsQuestions[5]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td><?php echo e($department->get("subjectByStandardAnswers")[5]->get($question->id)); ?></td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr style="background-color: #d3d19d;">
            <td><?php echo e($odsekime); ?> - Стандард 5. укупно</td>
            <?php $__currentLoopData = $standardsQuestions[5]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td><?php echo e($standardsAverageMark[5]->get($question->id)); ?></td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        </tbody>
    </table>
    <br>

    <br>
    <div class="header-2 paragraph-text">
        Стандард 7: Студентска процена квалитета наставника и сарадника
    </div>
    <br>
    <div class="paragraph-text">
        Табела 3. Стандард 7
    </div>
    <table class="tabela" style="page-break-inside:avoid;">
        <tr>
            <th>Студијски програм</th>
            <?php $__currentLoopData = $standardsQuestions[7]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <th><?php echo e($question->text); ?></th>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tr>
        <tbody style="page-break-inside:avoid;">
        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($department->get('name')); ?></td>
                <?php $__currentLoopData = $standardsQuestions[7]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td><?php echo e($department->get("subjectByStandardAnswers")[7]->get($question->id)); ?></td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr style="background-color: #d3d19d;">
            <td><?php echo e($odsekime); ?> - Стандард 7. укупно</td>
            <?php $__currentLoopData = $standardsQuestions[7]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td><?php echo e($standardsAverageMark[7]->get($question->id)); ?></td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        </tbody>
    </table>
    <br>




    <br>
    <div class="header-2 paragraph-text">
        Стандард 8 - Студентска процена сопственог доприноса квалитету наставног процеса - Квалитет студената
    </div>
    <br>
    <div class="paragraph-text">
        Табела 4. Стандард 8
    </div>
    <table class="tabela" style="page-break-inside:avoid;">
        <tr>
            <th>Студијски програм</th>
            <?php $__currentLoopData = $semesterQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <th><?php echo e($question->text); ?></th>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tr>
        <tbody style="page-break-inside:avoid;">
        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($department->get('name')); ?></td>
                <?php $__currentLoopData = $semesterQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td><?php echo e($department->get('semesterAnswers')->get($question->id)); ?></td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr style="background-color: #d3d19d;">
            <td><?php echo e($odsekime); ?> укупно</td>
            <?php $__currentLoopData = $semesterQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td><?php echo e($semesterAnswers->get($question->id)); ?></td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        </tbody>
    </table>
    <br>

    <div class="header-2 paragraph-text">
        Стандарди  9, 10 и 11 -  Студенти су оценили квалитет наставних средстава, рад стручних служби и хигијену у Школи
    </div>
    <br>
    <div class="paragraph-text">
        Табела 5. Стандарди  9, 10 и 11
    </div>
    <table class="tabela" style="page-break-inside:avoid;">
        <tr>
            <th>Студијски програм</th>
            <?php $__currentLoopData = $otherQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <th><?php echo e($question->text); ?></th>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tr>
        <tbody style="page-break-inside:avoid;">
        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($department->get('name')); ?></td>
                <?php $__currentLoopData = $otherQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <td><?php echo e($department->get('otherAnswers')->get($question->id)); ?></td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr style="background-color: #d3d19d;">
            <td><?php echo e($odsekime); ?> укупно</td>
            <?php $__currentLoopData = $otherQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td><?php echo e($otherAnswers->get($question->id)); ?></td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        </tbody>
    </table>
    <br>
   
    <br>
    <div class="header-2 paragraph-text">
        Табеларни приказ oцена педагошког рада наставника и сарадника:
    </div>
    <br>
    <table class="tabela" style="page-break-inside:avoid;">

        <tr>
            <th><i><?php echo e($odsekime); ?></i></th>
            <th>Број анкетираних студената / број првоуписаних</th>
            <th>Проценат анкетираних студената</th>
            <th>Укупно оцена</th>
            <th>Просечна оцена</th>
        </tr>

        <tbody style="page-break-inside:avoid;">
        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($department->get('name')); ?></td>
                <td><?php echo e($department->get('surveyed')); ?>/<?php echo e($department->get('total')); ?></td>
                <td><?php echo e($department->get('percentage')); ?>%</td>
                <td><?php echo e($department->get('markCount')); ?></td>
                <td><?php echo e($department->get('averageMark')); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr class="last">
            <td><?php echo e($odsekime); ?> укупно</td>
            <td><?php echo e($surveyedCount); ?>/<?php echo e($studentTotal); ?></td>
            <td><?php echo e($surveyedPerc); ?>%</td>
            <td>137</td>
            <td><?php echo e($departmentAverage); ?></td>
        </tr>
        </tbody>
    </table>
    <br>
    <div class="paragraph-text">
        <b>Просечна оцена свих наставника и сарадника је <?php echo e($teacherAverage->get('numeric')); ?> </b>
    </div>
    <br>
    <br>
    <div class="paragraph-text">
        Укупно су студенти на свим студијским програмима основних студија, у зимском семестру, слушали наставу из <?php echo e($subjectCount); ?> предмета. Студенти су оценили квалитет свих предмета, просечном оценом <b><?php echo e($subjectOverview->get('numeric')); ?> </b>. По студијсим програмима то изгледа:
    </div>
    <br>
    <table class="tabela" style="page-break-inside:avoid;">

        <tr >
            <th colspan="3" style="font-weight: 700; font-size: 1.3em;">СТАТИСТИКА ОЦЕЊЕНИХ ПРЕДМЕТА</th>
        </tr>
        <tr>
            <th>Студијски програм</th>
            <th>Број оцењиваних предмета</th>
            <th>Просечна оцена</th>
        </tr>

        <tbody style="page-break-inside:avoid;">
        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($department->get('name')); ?></td>
                <td><?php echo e($department->get('subjectCount')); ?></td>
                <td><?php echo e($department->get('subjectAverage')); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr style="background-color: #d3d19d;">
            <td><?php echo e($odsekime); ?></td>
            <td><?php echo e($subjectCount); ?></td>
            <td><?php echo e($subjectOverview->get('numeric')); ?></td>
        </tr>
        </tbody>
    </table>
    <br>
    
    <br>

    
    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="header-2">
        <?php echo e($department->get('name')); ?>

        </div>
        <br>
        <div class="paragraph-text">
            У анкети, на овом студијском програму, учествовало је <?php echo e($department->get('surveyed')); ?> студената од <?php echo e($department->get('total')); ?> првоуписана на овај студијски програм (<?php echo e($department->get('percentage')); ?>%).
            Оцењиван је рад укупно наставника <?php echo e($department->get('teacherCount')); ?> (<?php echo e($department->get('markCount')); ?> оценa), на све три године студија. Просечна оцена свих наставника, на овом студијском програму је <b><?php echo e($department->get('teacherAverage')->get('numeric')); ?> </b>.
        </div>
        <br>
        
        <table class="tabela" style="page-break-inside:avoid;">

            <tr>
                <th style="background-color: #0f64c0; color: #fff;">Студијски програм</th>
                <th>Број анкетираних /уписаних студената</th>
                <th>Проценат анкетираних студената</th>
                <th>Број оцењиваних наставника/ Укупно оцена</th>
                <th>Просечна оцена</th>
            </tr>

            <tbody style="page-break-inside:avoid;">
            <tr>
                <td style="background-color: #0f64c0; color: #fff;"><?php echo e($department->get('shorthand')); ?></td>
                <td><?php echo e($department->get('surveyed')); ?>/<?php echo e($department->get('total')); ?></td>
                <td><?php echo e($department->get('percentage')); ?>%</td>
                <td><?php echo e($department->get('teacherCount')); ?>/<?php echo e($department->get('markCount')); ?></td>
                <td><?php echo e($department->get('teacherAverage')->get('numeric')); ?></td>
            </tr>
            </tbody>
        </table>
        <br>
        <div class="paragraph-text">
            Укупно су студенти, на све три године студија, слушали наставу из <?php echo e($department->get('subjectCount')); ?> предмета.
        </div>
        <br>
        <table class="tabela" style="page-break-inside:avoid;">
            <tr>
                <th>Студијски програм</th>
                <th>Број оцењиваних предмета</th>
                <th>Просечна оцена</th>
            </tr>

            <tbody style="page-break-inside:avoid;">
            <tr>
                <td><?php echo e($department->get('shorthand')); ?></td>
                <td><?php echo e($department->get('subjectCount')); ?></td>
                <td><?php echo e($department->get('subjectAverage')); ?></td>
            </tr>
            </tbody>
        </table>
        <br>
        <div class="paragraph-text">
            Оцене свих оцењиваних аспеката, по годинама студија, дате су у наредним табелама.
        </div>
        <br>
        <?php $__currentLoopData = $department->get('years'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mini-head">
                <b><?php echo e($year->get('year')); ?>. ГОДИНА </b>
            </div>
            <div class="paragraph-text">
                На <b><?php echo e($year->get('year')); ?>. години студија</b>, у анкети је учествовало <?php echo e($year->get('surveyed')); ?> студената. Студенти су оцењивали педагошки рад <?php echo e($year->get('teacherCount')); ?> наставника и сарадника (<?php echo e($year->get('markCount')); ?> оцена) из <?php echo e($year->get('subjectCount')); ?> предмета. Просечна оцена свих наставника <?php echo e($year->get('year')); ?>. године студија је <b><?php echo e($year->get('teacherAverage')->get('numeric')); ?> .</b>
            </div>
            <br>
            
            <div class="paragraph-text">
                Табела 1. Стандард 4
            </div>
            <table class="tabela" style="page-break-inside:avoid;">
                <tr>
                    <td><?php echo e($department->get('shorthand')); ?>  <?php echo e($year->get('year')); ?>. година</td>
                </tr>
                <tr>
                    <?php $__currentLoopData = $standardsQuestions[4]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo e($question->text); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
                </tr>
                <tbody style="page-break-inside:avoid;">
                    <tr>
                        <?php $__currentLoopData = $standardsQuestions[4]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td><?php echo e($year->get("subjectAnswersByStandardFour")->get($question->id)); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </tbody>
            </table>
            <br>
        
            <br>
            <div class="paragraph-text">
                Табела 2. Стандард 5
            </div>
            <table class="tabela" style="page-break-inside:avoid;">
                <tr>
                    <td><?php echo e($department->get('shorthand')); ?>  <?php echo e($year->get('year')); ?>. година</td>
                </tr>
                <tr>
                    <?php $__currentLoopData = $standardsQuestions[5]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo e($question->text); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
                </tr>
                <tbody style="page-break-inside:avoid;">
                    <tr>
                        <?php $__currentLoopData = $standardsQuestions[5]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td><?php echo e($year->get("subjectAnswersByStandardFive")->get($question->id)); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </tbody>
            </table>
            <br>
        
            <br>
            <br>
            <div class="paragraph-text">
                Табела 3. Стандард 7
            </div>
            <table class="tabela" style="page-break-inside:avoid;">
                <tr>
                    <td><?php echo e($department->get('shorthand')); ?>  <?php echo e($year->get('year')); ?>. година</td>
                </tr>
                <tr>
                    <?php $__currentLoopData = $standardsQuestions[7]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo e($question->text); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
                </tr>
                <tbody style="page-break-inside:avoid;">
                    <tr>
                        <?php $__currentLoopData = $standardsQuestions[7]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td><?php echo e($year->get("subjectAnswersByStandardSeven")->get($question->id)); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </tbody>
            </table>
            <br>

            <br>
            <div class="paragraph-text">
                Табела 4. Стандард 8
            </div>
            <table class="tabela" style="page-break-inside:avoid;">

                <tr>
                    <th colspan="<?php echo e($year->get('semesterAnswers')); ?>" style="font-size: 1em;"><?php echo e($department->get('shorthand')); ?>  <?php echo e($year->get('year')); ?>. година</th>
                </tr>

                <tbody style="page-break-inside:avoid;">
                <tr>
                    <?php $__currentLoopData = $semesterQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td><?php echo e($question->text); ?></td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <?php $__currentLoopData = $semesterQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td><?php echo e($year->get('semesterAnswers')->get($question->id)); ?></td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                </tbody>
            </table>
            <br>
            <div class="paragraph-text">
                Табела 5. Стандарди  9, 10 и 11
            </div>
            <table class="tabela" style="page-break-inside:avoid;">

                <tr>
                    <th colspan="<?php echo e($year->get('otherAnswers')); ?>" style="font-size: 1em;"><?php echo e($department->get('shorthand')); ?>  <?php echo e($year->get('year')); ?>. година</th>
                </tr>

                <tbody style="page-break-inside:avoid;">
                <tr>
                    <?php $__currentLoopData = $otherQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td><?php echo e($question->text); ?></td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <?php $__currentLoopData = $otherQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td><?php echo e($year->get('otherAnswers')->get($question->id)); ?></td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                </tbody>
            </table>
            <br>
            <div class="paragraph-text">
                Табела 6. Табеларни приказ оцена наставника
            </div>
            <table class="tabela" style="page-break-inside:avoid;">

                <tr style="font-size: 1em; padding: 5px 10px;">
                    <th colspan="4"><?php echo e($department->get('shorthand')); ?>  <?php echo e($year->get('year')); ?>. година</th>
                </tr>

                <tbody style="page-break-inside:avoid;">
                <?php $__currentLoopData = $year->get('subjects'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($subject->get('name')); ?></td>
                        <td>Н</td>
                        <td><?php echo e($subject->get('teacher')); ?></td>
                        <td><?php echo e($subject->get('teacherAverage')); ?></td>
                    </tr>
                    <?php if($subject->get('teacher_alt')): ?>
                    <tr>
                        <td><?php echo e($subject->get('name')); ?></td>
                        <td>С</td>
                        <td><?php echo e($subject->get('teacher_alt')); ?></td>
                        <td><?php echo e($subject->get('teacherAverage')); ?></td>
                    </tr>
                <?php endif; ?>
                    <?php if($subject->get('assistant')): ?>
                        <tr>
                            <td><?php echo e($subject->get('name')); ?></td>
                            <td>С</td>
                            <td><?php echo e($subject->get('assistant')); ?></td>
                            <td><?php echo e($subject->get('assistantAverage')); ?></td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
</div>
</body>
</html><?php /**PATH /home/akademij/public_html/anketaon/resources/views/admin/export/report.blade.php ENDPATH**/ ?>