@foreach ($subjects as $subject)

    
    <div class="row">
        <div class="col text-center h3">
            {{ $subject->name }}
        </div>
        @if($subject->block_id > 0)
        <p class="p-2" style="background-color:darkgreen; color:white; font-size: 10px; border-radius: 5px;">
            Предмет изборног блока {{ $subject->block_id }}
        </p>
        @endif
    </div>
    <div class="row mt-4">
        <div class="col-md-4 h4 align-middle" style="line-height:2em;">
            {{ $subject->teacher->name }}
        </div>
        <div class="col-md-8">
            @include('survey.partials.mark_radios', [
                'name' => "subject-{$subject->id}-teacher-{$subject->teacher_id}",
                'checked' => $answers->get($subject->id)[$subject->teacher_id] ?? null,
            ])
        </div>
    </div>

    @if($subject->teacher_alt)
    <div class="row mt-3">
        <div class="col-md-4 h4">
            {{ $subject->teacher_alt->name }}
        </div>
        <div class="col-md-8">
            @include('survey.partials.mark_radios', [
                'name' => "subject-{$subject->id}-teacher_alt-{$subject->teacher_alt_id}",
                'checked' => $answers->get($subject->id)[$subject->teacher_alt_id] ?? null,
            ])
        </div>
    </div>
@endif


    @if($subject->assistant)
        <div class="row mt-3">
            <div class="col-md-4 h4">
                {{ $subject->assistant->name }}
            </div>
            <div class="col-md-8">
                @include('survey.partials.mark_radios', [
                    'name' => "subject-{$subject->id}-assistant-{$subject->assistant_id}",
                    'checked' => $answers->get($subject->id)[$subject->assistant_id] ?? null,
                ])
            </div>
        </div>
    @endif
    <hr>
@endforeach
