<?php

use App\Models\Question;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class QuestionSeeder extends Seeder
{
    protected $questions = [
        Question::TYPE_TEACHER => [
            'Наставник је објективно оцењивао мој рад',
            'Наставник потпуно образлаже градиво',
            'Наставник подржава и подстиче дијалог као вид унапређења знања.',
            'Наставник инсистира на повезивању градива са примерима из праксе',
            'Питања наставника су јасна и недвосмислена.',
            'Наставник ме мотивише и инспирише на рад',
            'Комуникација са наставником/сарадником је одговарајућа',
            'Укупно гледано, у распону од 1 до 5, наставника бих оценио/оценила следећом оценом.',
        ],
        Question::TYPE_SUBJECT => [
            'Предмет је допринео да боље разумем проблеме које он покрива.',
            'Предмет ме подстиче на размишљање.',
            'Укупно гледано, у распону од 1 до 5 овај предмет бих оценио/оценила следећом оценом.',
            'Литература за овај предмет је доступна.',
            'Предмет је добро организован.',
            'Вежбе ми користе у праћењу предмета',
            'Предиспитне, испитне обавезе и начин бодовања су јасно дефинисани',
        ],
        Question::TYPE_OTHER => [
            'Задовољан/а сам радом студентске службе',
            'Задовољан/а сам радом библиотеке',
            'Задовољан/а сам радом студентског парламента',
            'Задовољан/а сам техничком опремљеношћу лабораторија',
        ],
        Question::TYPE_TEXTANSWER => [
            'Наведите оно што Вас нисмо питали, а мислите да је важно за унапређење наставе:',
        ],
        Question::TYPE_SEMESTERS => [
            'Прошлог семестра био/ла сам редовна на настави',
            'Током протеклог семестра активно сам учествовао/ла у настави',
            'У прошлом семестру учио/ла сам редовно већину предмета',
            'Задовољан/а сам техничком опремљеношћу лабораторија',
            'У претходном семестру остварио/ла сам предиспитне обавезе у оквиру теорије из већине предмета',
            'У претходном семетстру остварио/ла сам предиспитне обавезе у оквиру вежби из већине предмета',
            'Прошлог семестра стекао/ла сам нова теоријска знања ',
            'Током протеклог семестра стекао/ла сам нова практична знања ',
        ],
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $questions = [];

        foreach ($this->questions as $type => $texts) {
            foreach ($texts as $text) {
                $questions[] = [
                    'type' => $type,
                    'text' => $text,
                ];
            }
        }

        DB::table('questions')->insert($questions);
    }
}
